/*  */
/*     HAMEG GmbH                                                          */
/*     Sample program for Interface HO79                                   */
/*     Communication with HAMEG scope;            Command : "ID?"          */
/*  */

#include <stdio.h>
#include <dos.h>
#include <param.h>
#include <mc.h>

#include <bios.h>
#include <conio.h>

/*  */

int main (int, char * []);

/*  */

struct param_set	id_param_set = {
	"ID - Demo program for HO79 + HO80 (IEEE transfer) ",   "ID dev=b",
	{ {"dev", "device"},
	  {"seg", "segment"},
	  {"", ""}, {"", ""}, {"", ""}, {"", ""},
	  {"", ""}, {"", ""}, {"", ""}, {"", ""}  }
};

/*  */
/*                                m a i n                                  */
/*  */

int main (argc, argv)
int		argc;
char	*argv[];
{
int 	ieee_chef, my_address, status, anz;
char    *response;

	clrscr();
	seg = 0xc000;
	if ( (param (argc, argv, &id_param_set) !=0) || (argc<=1))
		return(1);
	HO80_SEG = seg;
	if (ieee_se(HO80_SEG) != 0) {
		printf ("HO80-IEEE nicht gefunden");
		return (2);
	}
	ieee_chef = 0;                          /*  IEEE-488 controller   */
	my_address = 21;                        /*  "my" device address  */
	init (&ieee_chef,&my_address);      /*  Initialisation of HO80 card  */
	delay (3000);               /* Wait until initialisation terminated!  */

	iwd (&status, "ID?", &dev);
	if (status !=0) {
		printf ("ERROR  iwd status : %2x (hex)",status);
		return (1);
	}
	response = "                                            ";
	ird (&status, &dev, &anz, response);

	if (status==0)  printf (" %s", response);
	else {
		printf ("ERROR  ird status : %2x (hex)",status);
		return (1);
	}
	return(0);
}
